#pragma once

#include <infra/netmon/state_index.h>
#include <infra/netmon/state_index_history.h>

namespace NNetmon {
    class THistoryRequester: public TNonCopyable {
    public:
        THistoryRequester(const TTopologyStorage& topologyStorage);
        ~THistoryRequester();

        NThreading::TFuture<TSwitchPairIndex::TRef> CollectSwitchHistoryState(
                const TInstant& requestedTs, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const;
        NThreading::TFuture<TLinePairIndex::TRef> CollectLineHistoryState(
                const TInstant& requestedTs, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const;
        NThreading::TFuture<TDatacenterPairIndex::TRef> CollectDatacenterHistoryState(
                const TInstant& requestedTs, const TProbeAggregatorKey& key) const;

        NThreading::TFuture<TSwitchPairStateHistory::TRef> CollectSwitchHistorySeries(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TSwitchPairKey& pairKey) const;
        NThreading::TFuture<TLinePairStateHistory::TRef> CollectLineHistorySeries(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const;
        NThreading::TFuture<TDatacenterPairStateHistory::TRef> CollectDatacenterHistorySeries(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
