#pragma once

#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/library/requester.h>
#include <infra/netmon/topology/topology_storage.h>

namespace NNetmon {
    class TInfraUpdater: public TNonCopyable {
    public:
        TInfraUpdater(const TTopologyStorage& topologyStorage);
        ~TInfraUpdater();

        // NB: this method isn't called very frequently,
        // so the result is recalculated on every call.
        bool IsInfraEventOngoing(const TStringBuf& dc) const;

        TThreadPool::TFuture SpinAndWait() noexcept;

    private:
        TInfraUpdater(const TTopologyStorage& topologyStorage, bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
