#include <infra/netmon/library/api_handler_helpers.h>

namespace NNetmon {
    EContentType ExtractContentType(const THttpHeaders& headers) {
        for (auto it(headers.Begin()); it != headers.End(); ++it) {
            if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("Content-Type")) == 0) {
                if (it->Value() == TStringBuf("application/x-protobuf")) {
                    return EContentType::CodedProtobuf;
                } else if (it->Value() == TStringBuf("application/x-coded-protobuf")) {
                    return EContentType::CodedProtobuf;
                } else {
                    return EContentType::Json;
                }
            }
        }
        return EContentType::Json;
    }

    TUserCredentials ExtractCredentials(const THttpHeaders& headers) {
        bool properForwaredFor = false;
        TString sessionId, oAuthToken, userIp, host, userAgent;
        for (auto it(headers.Begin()); it != headers.End(); ++it) {
            if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("Cookie")) == 0) {
                const THttpCookies parsedCookies(it->Value());
                sessionId = parsedCookies.Get(TStringBuf("Session_id"));
            } else if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("X-Forwarded-For-Y")) == 0
                       || (AsciiCompareIgnoreCase(it->Name(), TStringBuf("X-Forwarded-For")) == 0 && !properForwaredFor)) {
                properForwaredFor = (it->Name() == TStringBuf("X-Forwarded-For-Y"));
                StringSplitter(it->Value()).Split(',').Take(1).CollectInto(&userIp);
            } else if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("Host")) == 0) {
                host = it->Value();
            } else if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("Authorization")) == 0 && it->Value().StartsWith(TStringBuf("OAuth "))) {
                oAuthToken = it->Value().substr(6, it->Value().size() - 6);
            } else if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("User-Agent")) == 0) {
                userAgent = it->Value();
            }
        }
        return {sessionId, oAuthToken, userIp, host, userAgent};
    }

    TInstant ExtractStartTime(const THttpHeaders& headers) {
        for (auto it(headers.Begin()); it != headers.End(); ++it) {
            if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("X-Start-Time")) == 0) {
                ui64 startTime = 0;
                if (TryFromString<ui64>(it->Value(), startTime)) {
                    return TInstant::MicroSeconds(startTime);
                }
            }
        }
        return TInstant::Zero();
    }

    ui64 ExtractReportsCount(const THttpHeaders& headers) {
        for (auto it(headers.Begin()); it != headers.End(); ++it) {
            if (AsciiCompareIgnoreCase(it->Name(), TStringBuf("X-Netmon-Reports-Count")) == 0) {
                ui64 reportsCount = 0;
                if (TryFromString<ui64>(it->Value(), reportsCount)) {
                    return reportsCount;
                }
            }
        }
        return 0;
    }
}
