#include <infra/netmon/library/api_handler_helpers.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NNetmon;

class TApiHandlerHelpersTest: public TTestBase {
    UNIT_TEST_SUITE(TApiHandlerHelpersTest);
    UNIT_TEST(TestExtractCredentials)
    UNIT_TEST_SUITE_END();

private:
    inline void TestExtractCredentials() {
        {
            THttpHeaders headers;
            headers.AddHeader("Cookie", "Session_id=cookie; another=test");
            headers.AddHeader("X-Forwarded-For", "client1, client2");
            headers.AddHeader("Host", "host");
            headers.AddHeader("User-Agent", "user-Agent");
            const auto cred(ExtractCredentials(headers));
            UNIT_ASSERT_EQUAL(cred.SessionId, "cookie");
            UNIT_ASSERT_EQUAL(cred.UserIp, "client1");
            UNIT_ASSERT_EQUAL(cred.Host, "host");
            UNIT_ASSERT_EQUAL(cred.UserAgent, "user-Agent");
        }

        {
            THttpHeaders headers;
            headers.AddHeader("X-Forwarded-For", "client1");
            const auto cred(ExtractCredentials(headers));
            UNIT_ASSERT_EQUAL(cred.SessionId, "");
            UNIT_ASSERT_EQUAL(cred.UserIp, "client1");
            UNIT_ASSERT_EQUAL(cred.Host, "");
        }

        {
            THttpHeaders headers;
            headers.AddHeader("X-Forwarded-For", "a");
            headers.AddHeader("X-Forwarded-For-Y", "b");
            headers.AddHeader("X-Forwarded-For", "c");
            const auto cred(ExtractCredentials(headers));
            UNIT_ASSERT_EQUAL(cred.UserIp, "b");
        }
    }
};

UNIT_TEST_SUITE_REGISTRATION(TApiHandlerHelpersTest);
