#pragma once

#include <infra/netmon/library/boxes.h>

#include <library/cpp/threading/future/future.h>

namespace NNetmon {
    struct TUserState {
        TUserState()
            : Login()
            , YandexUid()
            , IsActive(false)
        {
        }

        TUserState(const TString& login, const TString& yandexUid, bool isActive)
            : Login(login)
            , YandexUid(yandexUid)
            , IsActive(isActive)
        {
        }

        TString Login;
        TString YandexUid;
        bool IsActive;
    };

    class TBlackbox: public TNonCopyable {
    public:
        TBlackbox();
        ~TBlackbox();

        NThreading::TFuture<TUserState> FindBySessionId(
            const TString& sessionId, const TString& userIp, const TString& hostName) noexcept;
        NThreading::TFuture<TUserState> FindByOAuthToken(
            const TString& oAuthToken, const TString& userIp) noexcept;

    private:
        class TImpl;
        TLazyLockedBox<TImpl> Impl;
    };
}
