#include <infra/netmon/library/boxes.h>
#include <infra/netmon/library/thread_pool.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

#include <util/generic/xrange.h>

using namespace NNetmon;

class TPlainLockedBoxTest: public TTestBase {
    UNIT_TEST_SUITE(TPlainLockedBoxTest);
    UNIT_TEST(TestCounter)
    UNIT_TEST_SUITE_END();

private:
    inline void TestCounter() {
        TPlainLockedBox<ui64> box;
        TVector<NNetmon::TThreadPool::TFuture> futures;
        for (const auto& x : xrange(1000)) {
            Y_UNUSED(x);
            futures.emplace_back(NNetmon::TThreadPool::Get()->Add([&box]() {
                (*box.Own())++;
            }));
        }
        NThreading::WaitExceptionOrAll(futures).Wait();
        UNIT_ASSERT_EQUAL(*box.Own(), 1000);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TPlainLockedBoxTest);

class TAtomicLockedBoxTest: public TTestBase {
    UNIT_TEST_SUITE(TAtomicLockedBoxTest);
    UNIT_TEST(TestLifeTime)
    UNIT_TEST_SUITE_END();

private:
    class TCounter : public TNonCopyable {
    public:
        using TBox = TAtomicLockedBox<TCounter>;

        TCounter(TAtomic& counter)
            : Counter(counter)
        {
            AtomicIncrement(Counter);
        }

        ~TCounter() {
            AtomicDecrement(Counter);
        }

    private:
        TAtomic& Counter;
    };

    inline void TestLifeTime() {
        TAtomic counter = 0;
        TCounter::TBox::TRef box(TCounter::TBox::Make(counter));
        TVector<NNetmon::TThreadPool::TFuture> futures;
        for (const auto& x : xrange(1000)) {
            Y_UNUSED(x);
            futures.emplace_back(NNetmon::TThreadPool::Get()->Add([box, &counter]() {
                auto obj(MakeAtomicShared<TCounter>(counter));
                box->Swap(obj);
            }));
        }
        NThreading::WaitExceptionOrAll(futures).Wait();
        UNIT_ASSERT_EQUAL(AtomicGet(counter), 1);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TAtomicLockedBoxTest);
