#pragma once

#include <infra/netmon/library/clickhouse/pool.h>

#include <library/cpp/threading/future/future.h>

#include <util/generic/singleton.h>

namespace NNetmon {
    class TClickhouseClient : public TNonCopyable {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        using TFuture = NThreading::TFuture<void>;
        using TPromise = NThreading::TPromise<void>;

        class TQueryOptions {
        public:
            TQueryOptions(const TString& query)
                : Query_(query)
                , Timeout_(TDuration::Seconds(60))
                , ShardIndex_(0)
            {
            }

            const TString& Query() const {
                return Query_;
            }
            inline TQueryOptions& SetQuery(const TString& query) noexcept {
                Query_ = query;
                return *this;
            }

            inline const TDuration& Timeout() const noexcept {
                return Timeout_;
            }
            inline TQueryOptions& SetTimeout(const TDuration& timeout) noexcept {
                Timeout_ = timeout;
                return *this;
            }

            inline std::size_t ShardIndex() const noexcept {
                return ShardIndex_;
            }
            inline TQueryOptions& SetShardIndex(std::size_t shardIndex) noexcept {
                ShardIndex_ = shardIndex;
                return *this;
            }
            TQueryOptions& RandomShardIndex() noexcept;

        private:
            // In case of insert this field should be set to table name
            TString Query_;
            TDuration Timeout_;
            std::size_t ShardIndex_;
        };

        static TClickhouseClient* Get() {
            return SingletonWithPriority<TClickhouseClient, 100003>();
        }

        ~TClickhouseClient();

        // Intends for execute select queries
        [[nodiscard]] TFuture Select(const TQueryOptions& options, NClickHouse::TSelectCallback cb) noexcept;

        // Intends for execute insert queries
        [[nodiscard]] TFuture Insert(const TQueryOptions& options, NClickHouse::TBlock&& block) noexcept;

        // Intends for execute arbitrary queries
        [[nodiscard]] TFuture Execute(const TQueryOptions& options) noexcept;

    private:
        TClickhouseClient();

        class TImpl;
        THolder<TImpl> Impl;
    };
}
