#include <infra/netmon/library/clickhouse/pool.h>

#include <library/cpp/logger/global/global.h>

namespace NNetmon {
    TClickhouseClientPool::TClientRef TClickhouseClientPool::Take() {
        THolder<NClickHouse::TClient> client(Acquire());
        return TClientRef(std::move(client), this);
    }

    THolder<NClickHouse::TClient> TClickhouseClientPool::Acquire() {
        THolder<NClickHouse::TClient> client;
        while (Clients.Dequeue(&client)) {
            try {
                client->Ping();
            } catch (...) {
                WARNING_LOG << "Connection to " << Options.Host << ":" << Options.Port
                            << " dropped: " << CurrentExceptionMessage() << Endl;
                continue;
            }
            return client;
        }
        // pool is empty or all connections are invalid, start new one
        return MakeHolder<NClickHouse::TClient>(Options);
    }

    void TClickhouseClientPool::Release(THolder<NClickHouse::TClient>&& client) noexcept {
        TAutoPtr<NClickHouse::TClient> ptr(client.Release());
        Clients.Enqueue(std::move(ptr));
    }
}
