#pragma once

#include <library/cpp/clickhouse/client/client.h>

#include <util/thread/lfqueue.h>

namespace NNetmon {
    class TClickhouseClientPool : public TNonCopyable, public TAtomicRefCount<TClickhouseClientPool> {
    public:
        using TRef = TIntrusivePtr<TClickhouseClientPool>;

        class TClientRef: public TPointerBase<TClientRef, NClickHouse::TClient> {
        public:
            inline TClientRef(THolder<NClickHouse::TClient>&& client, const TClickhouseClientPool::TRef& pool) noexcept
                : Client(std::move(client))
                , Pool(pool)
            {
            }

            inline TClientRef(TClientRef&& client) noexcept
                : Client(std::move(client.Client))
                , Pool(client.Pool)
            {
            }

            ~TClientRef() {
                Pool->Release(std::move(Client));
            }

            inline NClickHouse::TClient* Get() const noexcept {
                return Client.Get();
            }

        private:
            THolder<NClickHouse::TClient> Client;
            TClickhouseClientPool::TRef Pool;
        };

        template <typename... Args>
        static inline TRef Make(Args&&... args) {
            return new TClickhouseClientPool(std::forward<Args>(args)...);
        }

        TClientRef Take();

    private:
        inline TClickhouseClientPool(const NClickHouse::TClientOptions& options)
            : Options(options)
        {
        }

        THolder<NClickHouse::TClient> Acquire();
        void Release(THolder<NClickHouse::TClient>&& client) noexcept;

        const NClickHouse::TClientOptions Options;
        TAutoLockFreeQueue<NClickHouse::TClient> Clients;
    };
}
