#pragma once

#include <infra/netmon/library/clickhouse/client.h>
#include <infra/netmon/library/clickhouse/translate.h>

#include <util/generic/set.h>
#include <util/generic/hash.h>

namespace NNetmon {
    class TTableFactory: public TNonCopyable {
    public:
        using TRef = THolder<TTableFactory>;

        TTableFactory(std::size_t shardIndex);

        virtual ~TTableFactory() = default;

        TClickhouseClient::TFuture Run();

    protected:
        virtual void Execute() = 0;

        const std::size_t ShardIndex;
        TSet<TString> ExitingTables;
        TVector<TClickhouseClient::TFuture> Futures;

    private:
        TClickhouseClient::TPromise Promise;
    };

    class TTableMaintainer: public TTableFactory {
    public:
        TTableMaintainer(std::size_t shardIdx, const TStringBuf& tableTemplate,
                         const TStringBuf& tablePrefix, const char* tableFormat,
                         std::size_t tableCount);

    protected:
        void Execute() override;

    private:
        void DropTables();
        void CreateTables();
        void MakeTable(const TString& tableName);

        const TStringBuf TableTemplate;
        const TStringBuf TablePrefix;
        const char* TableFormat;
        const std::size_t TableCount;
    };

    class TTableCreator: public TTableFactory {
    public:
        using TTableMap = THashMap<TString, TString>;

        TTableCreator(std::size_t shardIdx, const TTableMap& tableMap);

    protected:
        void Execute() override;

    private:
        const TTableMap TableMap;
    };
}
