#include <infra/netmon/library/clickhouse/translate.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/clickhouse/client/columns/string.h>
#include <library/cpp/clickhouse/client/columns/numeric.h>

using namespace NNetmon;

class TClickhouseTranslateTest: public TTestBase {
    UNIT_TEST_SUITE(TClickhouseTranslateTest);
    UNIT_TEST(TestTranslate)
    UNIT_TEST(TestEmptyTranslate)
    UNIT_TEST(TestWrongTranslate)
    UNIT_TEST_SUITE_END();

private:
    using TRow = std::tuple<TString, ui64>;

    inline void TestTranslate() {
        TVector<TString> first{"a", "b", "c"};
        TVector<ui64> second{1, 2, 3};
        UNIT_ASSERT_EQUAL(first.size(), second.size());

        NClickHouse::TBlock block;
        block.AppendColumn("first", NClickHouse::TColumnString::Create(first));
        block.AppendColumn("second", NClickHouse::TColumnUInt64::Create(second));

        auto result(TranslateClickhouseBlock<TRow>(block));
        UNIT_ASSERT_EQUAL(result.size(), first.size());
        UNIT_ASSERT_EQUAL(result.at(0), TRow("a", 1));
        UNIT_ASSERT_EQUAL(result.at(1), TRow("b", 2));
        UNIT_ASSERT_EQUAL(result.at(2), TRow("c", 3));
    }

    inline void TestEmptyTranslate() {
        NClickHouse::TBlock block;
        auto result(TranslateClickhouseBlock<TRow>(block));
        UNIT_ASSERT_EQUAL(result.size(), 0);
    }

    inline void TestWrongTranslate() {
        TVector<TString> first{"a", "b", "c"};

        NClickHouse::TBlock block;
        block.AppendColumn("first", NClickHouse::TColumnString::Create(first));

        UNIT_ASSERT_EXCEPTION(TranslateClickhouseBlock<TRow>(block), yexception);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TClickhouseTranslateTest);
