#include <infra/netmon/library/event_hub.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/xrange.h>

using namespace NNetmon;

class TEventHubTest: public TTestBase {
    UNIT_TEST_SUITE(TEventHubTest);
    UNIT_TEST(TestNotify)
    UNIT_TEST_SUITE_END();

private:
    inline void TestNotify() {
        TVoidEventHub::TRef eventHub(TVoidEventHub::Make());

        eventHub->Notify();

        size_t notified(0);
        const auto subscription1(eventHub->Subscribe([&]() {
            notified++;
        }));

        eventHub->Notify();

        {
            const auto subscription2(eventHub->Subscribe([&]() {
                notified++;
            }));
            for (const auto& index : xrange(10)) {
                eventHub->Notify();
                Y_UNUSED(index);
            }
        }

        eventHub->Notify();

        UNIT_ASSERT_EQUAL(notified, 22);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TEventHubTest);
