#include <infra/netmon/library/fences.h>
#include <infra/netmon/library/thread_pool.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

#include <util/generic/xrange.h>

using namespace NNetmon;

class TOwningFenceTest: public TTestBase {
    UNIT_TEST_SUITE(TOwningFenceTest);
    UNIT_TEST(TestEmpty)
    UNIT_TEST(TestWait)
    UNIT_TEST_SUITE_END();

private:
    inline void TestEmpty() {
        TOwningFence fence;
        fence.Wait();
    }

    inline void TestWait() {
        TAtomic counter = 1000;
        TOwningFence fence;
        for (const auto& x : xrange(AtomicGet(counter))) {
            Y_UNUSED(x);
            NNetmon::TThreadPool::Get()->AddAndForget([&counter, guard = MakeIntrusive<TOwningGuard>(fence)]() {
                Sleep(TDuration::MilliSeconds(10));
                AtomicDecrement(counter);
            });
        }
        fence.Wait();
        UNIT_ASSERT_EQUAL(AtomicGet(counter), 0);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TOwningFenceTest);

class TFutureFenceTest: public TTestBase {
    UNIT_TEST_SUITE(TFutureFenceTest);
    UNIT_TEST(TestWaitWithoutRetain)
    UNIT_TEST(TestWait)
    UNIT_TEST_SUITE_END();

private:
    inline void TestWaitWithoutRetain() {
        TFutureFence fence;
        fence.Wait().Wait();
    }

    inline void TestWait() {
        TAtomic counter = 1000;
        TFutureFence fence;
        for (const auto& x : xrange(AtomicGet(counter))) {
            Y_UNUSED(x);
            fence.Retain(NNetmon::TThreadPool::Get()->Add([&counter]() {
                Sleep(TDuration::MilliSeconds(10));
                AtomicDecrement(counter);
            }));
        }
        fence.Wait().Wait();
        UNIT_ASSERT_EQUAL(AtomicGet(counter), 0);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TFutureFenceTest);
