#pragma once

#include <library/cpp/threading/future/future.h>

namespace NNetmon {
    namespace {
        template <typename F>
        using TFutureResultType = typename NThreading::TFutureType<TFunctionResult<F>>;

        template <typename R>
        inline void FutureLinkImpl(NThreading::TPromise<R> promise, const NThreading::TFuture<R>& future) noexcept {
            try {
                promise.SetValue(future.GetValue());
            } catch (...) {
                promise.SetException(std::current_exception());
            }
        }

        template <>
        inline void FutureLinkImpl(NThreading::TPromise<void> promise, const NThreading::TFuture<void>& future) noexcept {
            try {
                future.GetValue();
            } catch (...) {
                promise.SetException(std::current_exception());
                return;
            }
            promise.SetValue();
        }

        template <typename F, typename R>
        inline NThreading::TFuture<TFutureResultType<F>> FutureChainImpl(const NThreading::TFuture<R>& future, F&& func, std::false_type) noexcept {
            auto promise(NThreading::NewPromise<TFutureResultType<F>>());
            future.Subscribe([promise, func] (const NThreading::TFuture<R>& future) noexcept {
                try {
                    func(future.GetValue()).Subscribe([promise] (const NThreading::TFuture<TFutureResultType<F>>& future) noexcept {
                        FutureLinkImpl(promise, future);
                    });
                } catch (...) {
                    // this hack is needed because of const qualifier of promise
                    NThreading::TPromise<TFutureResultType<F>>(promise).SetException(std::current_exception());
                }
            });
            return promise.GetFuture();
        };

        template <typename F>
        inline NThreading::TFuture<TFutureResultType<F>> FutureChainImpl(const NThreading::TFuture<void>& future, F&& func, std::true_type) noexcept {
            auto promise(NThreading::NewPromise<TFutureResultType<F>>());
            future.Subscribe([promise, func] (const NThreading::TFuture<void>& future) noexcept {
                try {
                    future.GetValue();
                    func().Subscribe([promise] (const NThreading::TFuture<TFutureResultType<F>>& future) noexcept {
                        FutureLinkImpl(promise, future);
                    });
                } catch (...) {
                    // this hack is needed because of const qualifier of promise
                    NThreading::TPromise<TFutureResultType<F>>(promise).SetException(std::current_exception());
                }
            });
            return promise.GetFuture();
        };
    }

    template <typename F, typename R>
    inline NThreading::TFuture<TFutureResultType<F>> FutureChain(const NThreading::TFuture<R>& future, F&& func) noexcept {
        return FutureChainImpl(
            future,
            std::move(func),
            typename std::is_same<R, void>::type()
        );
    };
}
