#include <infra/netmon/library/futures.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TFutureChainTest: public TTestBase {
    UNIT_TEST_SUITE(TFutureChainTest);
    UNIT_TEST(TestWithResult)
    UNIT_TEST(TestWithoutResult)
    UNIT_TEST(TestException)
    UNIT_TEST_SUITE_END();

private:
    struct TPod {
        const int Counter;
    };

    inline void TestWithResult() {
        const TPod source{12345};
        const TPod dest(FutureChain(NThreading::MakeFuture(source), [&](const TPod& obj) {
            UNIT_ASSERT_EQUAL(source.Counter, obj.Counter);
            return NThreading::MakeFuture(obj);
        }).GetValue());
        UNIT_ASSERT_EQUAL(source.Counter, dest.Counter);
    }

    inline void TestWithoutResult() {
        const TPod source{12345};
        FutureChain(NThreading::MakeFuture(source), [&](const TPod& obj) {
            UNIT_ASSERT_EQUAL(source.Counter, obj.Counter);
            return NThreading::MakeFuture();
        }).GetValue();
    }

    inline void TestException() {
        auto promise(NThreading::NewPromise<TPod>());
        promise.SetException("test");
        auto future(FutureChain(promise.GetFuture(), [&](const TPod&) {
            return NThreading::MakeFuture();
        }));
        UNIT_ASSERT_EXCEPTION(future.GetValue(), yexception);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TFutureChainTest);
