#include <infra/netmon/library/helpers.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/network/init.h>

using namespace NNetmon;

class TIpAddressTest: public TTestBase {
    UNIT_TEST_SUITE(TIpAddressTest);
    UNIT_TEST(TestString)
    UNIT_TEST(TestBytes)
    UNIT_TEST(TestProto)
    UNIT_TEST(TestCopy)
    UNIT_TEST_SUITE_END();

private:
    inline void TestString() {
        {
            TIpAddress addr(AF_INET, "127.0.0.1");
            UNIT_ASSERT_STRINGS_EQUAL(addr.ToString(), "127.0.0.1");
        }
        {
            TIpAddress addr(AF_INET6, "127.0.0.1");
            UNIT_ASSERT_STRINGS_EQUAL(addr.ToString(), "::");
        }
        {
            TIpAddress addr(AF_INET6, "::1");
            UNIT_ASSERT_STRINGS_EQUAL(addr.ToString(), "::1");
        }
        {
            TIpAddress addr(AF_INET, "::1");
            UNIT_ASSERT_STRINGS_EQUAL(addr.ToString(), "0.0.0.0");
        }
    }

    inline void TestBytes() {
        {
            TIpAddress source(AF_INET6, "::1");
            TIpAddress target(source.ToBytes());
            UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "::1");
        }
        {
            TIpAddress source(AF_INET6, "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
            TIpAddress target(source.ToBytes());
            UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
        }
        {
            TIpAddress target("");
            UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "");
        }
    }

    inline void TestProto() {
        {
            TIpAddress source(AF_INET6, "::1");
            TIpAddress target(source.ToProto());
            UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "::1");
        }
        {
            TIpAddress source(AF_INET6, "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
            TIpAddress target(source.ToProto());
            UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
        }
    }

    inline void TestCopy() {
        TIpAddress source(AF_INET6, "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
        TIpAddress target(source);
        UNIT_ASSERT_STRINGS_EQUAL(target.ToString(), "2a02:6b8:b040:1a3f:202:c9ff:fef0:1350");
    }
};

UNIT_TEST_SUITE_REGISTRATION(TIpAddressTest);

class TOtherTest: public TTestBase {
    UNIT_TEST_SUITE(TOtherTest);
    UNIT_TEST(TestAgentVersion)
    UNIT_TEST_SUITE_END();

private:
    inline void TestAgentVersion() {
        auto bad(ParseAgentVersion("wrong"));
        UNIT_ASSERT_EQUAL(bad, TAgentVersion(0, 0, 0, 0));

        auto good(ParseAgentVersion("v1.2.3+123"));
        UNIT_ASSERT_EQUAL(good, TAgentVersion(1, 2, 3, 123));
    }
};

UNIT_TEST_SUITE_REGISTRATION(TOtherTest);
