#pragma once

#include <utility>
#include <iterator>
#include <tuple>

namespace NNetmon {
    // from https://stackoverflow.com/questions/8511035/sequence-zip-function-for-c11

    namespace TImpl {
        template <typename TIter, typename... TIters>
        class TZipIterator {
        public:
            using value_type = std::tuple<
                const typename std::iterator_traits<TIter>::value_type&,
                const typename std::iterator_traits<TIters>::value_type&...
            >;

            TZipIterator(TIter&& head, TIters&&... tail)
                : Head_(std::forward<TIter>(head))
                , Tail_(std::forward<TIters>(tail)...)
            {
            }

            value_type operator*() const {
                return std::tuple_cat(std::tuple<const typename std::iterator_traits<TIter>::value_type&>(*Head_), *Tail_);
            }

            TZipIterator& operator++() {
                ++Head_;
                ++Tail_;
                return *this;
            }

            bool operator==(const TZipIterator& rhs) const {
                return Head_ == rhs.Head_ && Tail_ == rhs.Tail_;
            }

            bool operator!=(const TZipIterator& rhs) const {
                return !(*this == rhs);
            }

        private:
            TIter Head_;
            TZipIterator<TIters...> Tail_;
        };

        template <typename TIter>
        class TZipIterator<TIter> {
        public:
            using value_type = std::tuple<const typename std::iterator_traits<TIter>::value_type&>;

            TZipIterator(TIter&& head)
                : Head_(std::forward<TIter>(head))
            {
            }

            value_type operator*() const {
                return value_type(*Head_);
            }

            TZipIterator& operator++() {
                ++Head_;
                return *this;
            }

            bool operator==(const TZipIterator& rhs) const {
                return Head_ == rhs.Head_;
            }

            bool operator!=(const TZipIterator& rhs) const {
                return !(*this == rhs);
            }

        private:
            TIter Head_;
        };
    }

    template <typename TIter>
    class TSeq {
    public:
        using const_iterator = TIter;

        TSeq(TIter&& begin, TIter&& end)
            : Begin_(std::forward<TIter>(begin))
            , End_(std::forward<TIter>(end))
        {
        }

        TIter begin() {
            return std::move(Begin_);
        }

        TIter end() {
            return std::move(End_);
        }

    private:
        TIter Begin_, End_;
    };

    // WARNING: Undefined behavior if iterator lengths are different.
    template <typename... TSeqs>
    TSeq<TImpl::TZipIterator<typename TSeqs::const_iterator...>> ZipIterator(const TSeqs&... seqs) {
        return TSeq<TImpl::TZipIterator<typename TSeqs::const_iterator...>>(
            TImpl::TZipIterator<typename TSeqs::const_iterator...>(std::move(std::begin(seqs))...),
            TImpl::TZipIterator<typename TSeqs::const_iterator...>(std::move(std::end(seqs))...)
        );
    }
}
