#include <infra/netmon/library/memory_pool.h>
#include <infra/netmon/library/thread_pool.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

#include <util/generic/xrange.h>

using namespace NNetmon;

static TAtomic ObjectCounter;

class TSomeObjectFromPool: public TNonCopyable, public TSafeObjectFromPool<TSomeObjectFromPool> {
public:
    using TRef = THolder<TSomeObjectFromPool>;

    template <typename... Args>
    static inline TRef Make(TSomeObjectFromPool::TPool& pool) {
        return THolder(new (&pool) TSomeObjectFromPool());
    }

    TSomeObjectFromPool() {
        AtomicIncrement(ObjectCounter);
    }

    ~TSomeObjectFromPool() {
        AtomicDecrement(ObjectCounter);
    }

    inline void Verify() {
        Y_VERIFY(AtomicGet(ObjectCounter) > 0);
    }
};

class TMemoryPoolTest: public TTestBase {
    UNIT_TEST_SUITE(TMemoryPoolTest);
    UNIT_TEST(TestAllocation)
    UNIT_TEST_SUITE_END();

private:
    inline void TestAllocation() {
        ObjectCounter = 0;
        TSomeObjectFromPool::TPool pool;
        TVector<NNetmon::TThreadPool::TFuture> futures;
        for (const auto& x : xrange(100000)) {
            Y_UNUSED(x);
            futures.emplace_back(NNetmon::TThreadPool::Get()->Add([&pool]() {
                TSomeObjectFromPool::TRef obj(TSomeObjectFromPool::Make(pool));
                obj->Verify();
            }));
        }
        NThreading::WaitExceptionOrAll(futures).Wait();
        UNIT_ASSERT_EQUAL(AtomicGet(ObjectCounter), 0);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TMemoryPoolTest);
