#pragma once

#include <library/cpp/unistat/unistat.h>
#include <library/cpp/unistat/raii.h>

#include <util/string/cast.h>

namespace NNetmon {
    const TVector<double>& GetYasmBuckets();

    enum class ELibrarySignals {
        SchedulerIterationTime,
        NehClientParallelRequests,
        HttpClientParallelRequests,

        DumperProcessedRecords,
        DumperOutdatedRecords,
        DumperInsertionTime,

        HttpServerQueueTime,

        MemoryPoolAllocated
    };

    inline TString ToString(ELibrarySignals v) {
        switch (v) {
            case ELibrarySignals::SchedulerIterationTime:
                return "scheduler_iteration_time";
            case ELibrarySignals::NehClientParallelRequests:
                return "neh_client_parallel_requests";
            case ELibrarySignals::HttpClientParallelRequests:
                return "http_client_parallel_requests";

            case ELibrarySignals::DumperProcessedRecords:
                return "dumper_processed_records";
            case ELibrarySignals::DumperOutdatedRecords:
                return "dumper_outdated_records";
            case ELibrarySignals::DumperInsertionTime:
                return "dumper_insertion_time";

            case ELibrarySignals::HttpServerQueueTime:
                return "http_server_queue_time";

            case ELibrarySignals::MemoryPoolAllocated:
                return "memory_pool_allocated";
        };
    }

    class TLibraryStatsInitializer {
    public:
        void Init(TUnistat& t) const {
            t.DrillFloatHole("neh_client_parallel_requests", "amxx", NUnistat::TPriority(10), NUnistat::TStartValue(0), EAggregationType::LastValue);
            t.DrillFloatHole("http_client_parallel_requests", "amxx", NUnistat::TPriority(10), NUnistat::TStartValue(0), EAggregationType::LastValue);

            t.DrillFloatHole("dumper_processed_records", "summ", NUnistat::TPriority(10));
            t.DrillFloatHole("dumper_outdated_records", "summ", NUnistat::TPriority(10));

            t.DrillFloatHole("memory_pool_allocated", "ammv", NUnistat::TPriority(10));

            const auto& intervals = GetYasmBuckets();

            t.DrillHistogramHole("scheduler_iteration_time", "hgram", NUnistat::TPriority(10), intervals);

            t.DrillHistogramHole("dumper_insertion_time", "hgram", NUnistat::TPriority(10), intervals);

            t.DrillHistogramHole("http_server_queue_time", "hgram", NUnistat::TPriority(10), intervals);

        }
    };
}
