#pragma once

#include <library/cpp/threading/future/future.h>
#include <library/cpp/json/writer/json_value.h>

#include <util/generic/singleton.h>

namespace NNetmon {
    namespace NMongo {
        class TClient: public TNonCopyable {
            Y_DECLARE_SINGLETON_FRIEND()
        public:
            ~TClient();

            static TClient* Get() {
                return SingletonWithPriority<TClient, 100003>();
            }

            NThreading::TFuture<void> Insert(const TString& collection, const NJson::TJsonValue& value);
            NThreading::TFuture<void> Update(const TString& collection, const NJson::TJsonValue& selector, const NJson::TJsonValue& updater);
            NThreading::TFuture<void> Upsert(const TString& collection, const NJson::TJsonValue& selector, const NJson::TJsonValue& updater);

            NThreading::TFuture<void> Remove(const TString& collection, const NJson::TJsonValue& selector);

            NThreading::TFuture<TVector<NJson::TJsonValue>> Find(const TString& collection, const NJson::TJsonValue& selector=NJson::TJsonValue(NJson::JSON_MAP),
                                                                 size_t skip=0, size_t limit=0, const NJson::TJsonValue& fields=NJson::TJsonValue(NJson::JSON_MAP));

        private:
            TClient();

            class TImpl;
            THolder<TImpl> Impl;
        };
    }
}
