#pragma once

#include <library/cpp/msgpack/strbuf_adaptor.h>
#include <library/cpp/msgpack/string_adaptor.h>
#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NNetmon {
    template<class TContainer, class TValue>
    class TMsgpackIterator {
    public:
        TMsgpackIterator(const TContainer& object)
            : Object(object)
        {
        }

        inline TValue* begin() const {
            return Object.ptr;
        }

        inline TValue* end() const {
            return Object.ptr + Object.size;
        }

    private:
        TContainer Object;
    };

    using TMapIterator = TMsgpackIterator<msgpack::object_map, msgpack::object_kv>;
    using TListIterator = TMsgpackIterator<msgpack::object_array, msgpack::object>;
}
