#pragma once

#include <infra/netmon/library/helpers.h>
#include <infra/netmon/library/thread_pool.h>
#include <infra/netmon/library/boxes.h>

#include <library/cpp/threading/future/future.h>
#include <library/cpp/neh/multiclient.h>
#include <library/cpp/http/client/client.h>

namespace NNetmon {
    class TNehRequester: public TNonCopyable {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        using TFuture = NThreading::TFuture<NNeh::TResponseRef>;
        using TPromise = NThreading::TPromise<NNeh::TResponseRef>;

        ~TNehRequester();

        [[nodiscard]] TFuture MakeRequest(const NNeh::TMessage& msg,
                                          TInstant deadline = TInstant::Max(),
                                          TBaseThreadExecutor* pool = nullptr);

        void Destroy();

        static TNehRequester* Get() {
            return SingletonWithPriority<TNehRequester, 100003>();
        }

    private:
        TNehRequester();

        class TImpl;
        THolder<TImpl> Impl;
    };

    class THttpRequester: public TNonCopyable {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        using TFuture = NThreading::TFuture<NHttpFetcher::TResultRef>;
        using TPromise = NThreading::TPromise<NHttpFetcher::TResultRef>;

        ~THttpRequester();

        [[nodiscard]] TFuture MakeRequest(const TString& url,
                                          const TVector<TString>& headers = {},
                                          const NHttp::TFetchOptions& options = NHttp::TFetchOptions(),
                                          TBaseThreadExecutor* pool = nullptr);

        void Destroy();

        static THttpRequester* Get() {
            return SingletonWithPriority<THttpRequester, 100003>();
        }

    private:
        THttpRequester();

        class TImpl;
        THolder<TImpl> Impl;
    };
}
