#pragma once

#include <library/cpp/config/config.h>

#include <util/datetime/base.h>
#include <util/generic/singleton.h>

namespace NNetmon {
    class TLibrarySettings {
        Y_DECLARE_SINGLETON_FRIEND()
    public:
        struct TShard {
            TString Host;
            ui64 Port = 0;
            TString Index;
        };

        using TShardList = TVector<TShard>;

        size_t GetCpuGuarantee() const {
            return CpuGuarantee;
        }
        void SetCpuGuarantee(int value) {
            CpuGuarantee = value;
            HttpThreadPoolSize = Max(CpuGuarantee, 2UL);
            InterconnectThreadPoolSize = Max(CpuGuarantee, 2UL);
        }

        int GetHttpPort() const {
            return HttpPort;
        }
        void SetHttpPort(int port) {
            HttpPort = port;
        }

        int GetHttpThreadPoolSize() const {
            return HttpThreadPoolSize;
        }
        ui32 GetHttpMaxQueueSize() const {
            return HttpMaxQueueSize;
        }
        ui32 GetHttpMaxConnections() const {
            return HttpMaxConnections;
        }
        int GetHttpListenBacklog() const {
            return HttpListenBacklog;
        }
        const TDuration& GetHttpClientTimeout() const {
            return HttpClientTimeout;
        }

        int GetInterconnectPort() const {
            return InterconnectPort;
        }
        void SetInterconnectPort(int port) {
            InterconnectPort = port;
        }
        int GetInterconnectThreadPoolSize() const {
            return InterconnectThreadPoolSize;
        }

        const TShardList& GetClickHouseShards() const {
            return ClickHouseShards;
        }
        const TString& GetClickHouseUsername() const {
            return ClickHouseUsername;
        }
        const TString& GetClickHousePassword() const {
            return ClickHousePassword;
        }
        bool ShouldClickHouseUseCompression() const {
            return ClickHouseUseCompression;
        }
        size_t GetClickhousePoolSize() const {
            return ClickhousePoolSize;
        }

        const TString& GetBlackboxUrl() const {
            return BlackboxUrl;
        }
        void SetBlackboxUrl(const TString& url) {
            BlackboxUrl = url;
        }

        const TString& GetIamTokenUrl() const {
            return IamTokenUrl;
        }

        const TString& GetZookeeperAddress() const {
            return ZookeeperAddress;
        }
        const TString& GetZookeeperRoot() const {
            return ZookeeperRoot;
        }
        TString GetZookeeperUri() const;

        const TString& GetMongoUsername() const {
            return MongoUsername;
        }
        const TString& GetMongoPassword() const {
            return MongoPassword;
        }
        const TString& GetMongoAddress() const {
            return MongoAddress;
        }
        const TString& GetMongoDatabase() const {
            return MongoDatabase;
        }
        const TString& GetMongoReplicaSet() const {
            return MongoReplicaSet;
        }
        TString GetMongoUri() const;

        const TString& GetTvmAddress() const {
            return TvmAddress;
        }
        ui16 GetTvmPort() const {
            return TvmPort;
        }
        const TString& GetTvmAuthToken() const {
            return TvmAuthToken;
        }
        const TString& GetTvmNetmonAlias() const {
            return TvmNetmonAlias;
        }
        const TString& GetTvmBlackboxAlias() const {
            return TvmBlackboxAlias;
        }

        void EnableRequestLogs() {
            RequestLogsEnabled = true;
        }
        bool AreRequestLogsEnabled() const {
            return RequestLogsEnabled;
        }

        void Load(const NConfig::TConfig& config);

        static TLibrarySettings* Get() {
            return SingletonWithPriority<TLibrarySettings, 100000>();
        }

        static bool TryToParseShards(const NConfig::TConfig& config, TShardList& shards);

    private:
        TLibrarySettings();

        size_t CpuGuarantee;
        int HttpPort;
        int HttpThreadPoolSize;
        ui32 HttpMaxQueueSize;
        ui32 HttpMaxConnections;
        int HttpListenBacklog;
        TDuration HttpClientTimeout;

        int InterconnectPort;
        int InterconnectThreadPoolSize;

        TShardList ClickHouseShards;

        TString ClickHouseUsername;
        TString ClickHousePassword;
        bool ClickHouseUseCompression;
        size_t ClickhousePoolSize;

        TString BlackboxUrl;

        TString IamTokenUrl;

        TString ZookeeperAddress;
        TString ZookeeperRoot;

        TString MongoUsername;
        TString MongoPassword;
        TString MongoAddress;
        TString MongoDatabase;
        TString MongoReplicaSet;

        TString TvmAddress;
        ui16 TvmPort;
        TString TvmAuthToken;
        TString TvmNetmonAlias;
        TString TvmBlackboxAlias;

        bool RequestLogsEnabled;
    };
}
