#include <infra/netmon/library/token_bucket.h>

namespace NNetmon {
    bool TTokenBucket::TryConsume(ui64 tokens) {
        if (!Capacity || !RefillRatePerMs) {
            return true;
        }

        TGuard<TMutex> guard(Mutex);

        auto now(TInstant::Now());
        ui64 newTokens = (now - LastAccess).MilliSeconds() * RefillRatePerMs;
        LastAccess = now;

        Tokens += newTokens;
        if (Tokens > Capacity) {
            Tokens = Capacity;
        }

        if (Tokens >= tokens) {
            Tokens -= tokens;
            return true;
        }

        return false;
    }
}
