#pragma once

#include <util/datetime/base.h>
#include <util/system/mutex.h>

namespace NNetmon {
    class TTokenBucket: public TMoveOnly {
    public:
        TTokenBucket(ui64 capacity, ui64 refillRatePerMs)
            : Capacity(capacity)
            , Tokens(Capacity)
            , RefillRatePerMs(refillRatePerMs)
            , LastAccess(TInstant::Now())
        {
        }

        bool TryConsume(ui64 tokens);

    private:
        ui64 Capacity;
        ui64 Tokens;
        ui64 RefillRatePerMs;
        TInstant LastAccess;
        TMutex Mutex;
    };
}
