#include <infra/netmon/library/token_bucket.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TTokenBucketTest: public TTestBase {
    UNIT_TEST_SUITE(TTokenBucketTest);
    UNIT_TEST(TestBucket)
    UNIT_TEST_SUITE_END();

private:
    inline void TestBucket() {
        const ui64 capacity = 10000;
        const ui64 refillRatePerMs = capacity / 1000;

        TTokenBucket bucket(capacity, refillRatePerMs);

        UNIT_ASSERT(!bucket.TryConsume(capacity + 1));
        UNIT_ASSERT(bucket.TryConsume(capacity));

        Sleep(TDuration::MilliSeconds(600));

        UNIT_ASSERT(!bucket.TryConsume(capacity));
        UNIT_ASSERT(bucket.TryConsume(capacity / 2));
        UNIT_ASSERT(bucket.TryConsume(1));

        Sleep(TDuration::Seconds(1));
        UNIT_ASSERT(!bucket.TryConsume(capacity + 1));
        UNIT_ASSERT(bucket.TryConsume(capacity));
    }
};

UNIT_TEST_SUITE_REGISTRATION(TTokenBucketTest);
