LIBRARY()

OWNER(g:netmon)

SRCS(
    api_handler_helpers.cpp
    blackbox.cpp
    helpers.cpp
    iam.cpp
    metrics.cpp
    requester.cpp
    scheduler.cpp
    settings.cpp
    thread_pool.cpp
    token_bucket.cpp
    web_server.cpp
    clickhouse/client.cpp
    clickhouse/pool.cpp
    clickhouse/tables.cpp
    zookeeper.cpp
    mongo.cpp
)

PEERDIR(
    contrib/libs/flatbuffers
    contrib/libs/msgpack
    contrib/libs/protobuf
    contrib/libs/zookeeper
    infra/netmon/idl
    library/cpp/blockcodecs
    library/cpp/cache
    library/cpp/cgiparam
    library/cpp/clickhouse/client
    library/cpp/config
    library/cpp/consistent_hashing
    library/cpp/containers/intrusive_avl_tree
    library/cpp/deprecated/split
    library/cpp/http/client
    library/cpp/http/cookies
    library/cpp/http/server
    library/cpp/json
    library/cpp/logger/global
    library/cpp/mongo
    library/cpp/msgpack
    library/cpp/neh
    library/cpp/regex/libregex
    library/cpp/regex/pire
    library/cpp/threading/future
    library/cpp/threading/work_stealing
    library/cpp/tvmauth/client
    library/cpp/unistat
    library/cpp/zookeeper
    library/cpp/deprecated/atomic
)

GENERATE_ENUM_SERIALIZATION(zookeeper.h)

END()

RECURSE(
    ut
)
