#pragma once

#include <util/string/builder.h>

#include <tuple>

namespace NNetmon {
    namespace NAsyncZookeeper {
        namespace NImpl {
            template <typename T>
            inline void JoinImpl(TStringBuilder& builder, T&& path) noexcept {
                if (builder.empty()) {
                    builder << std::forward<T>(path);
                } else {
                    builder << TStringBuf("/") << std::forward<T>(path);
                }
            }

            template <typename T, typename... Args>
            inline void JoinImpl(TStringBuilder& builder, T&& path, Args&&... paths) noexcept {
                JoinImpl(builder, path);
                JoinImpl(builder, std::forward<Args>(paths)...);
            }

            template <class F>
            class TMemberRefHelper;

            template <typename Class, typename Return, typename Result, typename... Args>
            class TMemberRefHelper<Return (Class::*)(Result, Args...) noexcept> {
            public:
                using TMethod = Return (Class::*)(Result, Args...);
                using TFuture = typename std::decay_t<Result>::TFuture;

                inline TMemberRefHelper(TMethod method, typename Class::TRef self, Args... args)
                    : Method(method)
                    , Self(self)
                    , Arguments(std::make_tuple(args...))
                {
                }

                inline Return operator()(const TFuture& future) noexcept {
                    return Helper(future, std::index_sequence_for<Args...>{});
                }

            private:
                template <std::size_t... I>
                inline Return Helper(const TFuture& future, std::index_sequence<I...>) noexcept {
                    return (Self.Get()->*Method)(future.GetValue(), std::get<I>(Arguments)...);
                }

                TMethod Method;
                typename Class::TRef Self;
                std::tuple<std::decay_t<Args>...> Arguments;
            };
        }
    }
}
