#pragma once

#include <infra/netmon/topology/topology_storage.h>

namespace NNetmon {
    class TLinkPollerHostsUpdater: public TNonCopyable {
    public:
        using TSwitchSet = THashSet<TTopology::TSwitchRef>;
        using TSwitchSetRef = TAtomicSharedPtr<const TSwitchSet>;
        using THostSet = TTopologyStorage::THostSet;
        using THostSetRef = TTopologyStorage::THostSetRef;

        TLinkPollerHostsUpdater(const TTopologyStorage& topologyStorage);
        ~TLinkPollerHostsUpdater();

        void AddHost(const TTopology::THostRef& host);
        THostSetRef GetHosts() const;

        // returns switches in which all hosts have link poller enabled
        TSwitchSetRef GetSwitches() const;

        TThreadPool::TFuture SpinAndWait() noexcept;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
