#include <infra/netmon/link_poller_hosts.h>

#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TLinkPollerHostsTest: public TTestBase {
    UNIT_TEST_SUITE(TLinkPollerHostsTest);
    UNIT_TEST(TestLinkPollerHosts)
    UNIT_TEST_SUITE_END();

public:
    TLinkPollerHostsTest()
        : TopologyStorage(TGlobalTopology::GetTopologyStorage())
    {
    }

private:
    inline void TestLinkPollerHosts() {
        TTopology::TSwitchRef switch_(TopologyStorage.FindSwitch("vla1-1s124"));
        TTopology::THostRef hostA(TopologyStorage.FindHost("man1-1234.search.yandex.net"));
        UNIT_ASSERT(switch_);
        UNIT_ASSERT(hostA);

        TLinkPollerHostsUpdater updater(TopologyStorage);
        updater.AddHost(hostA);
        updater.SpinAndWait().Wait();
        auto hostSetA = updater.GetHosts();
        auto switchSetA = updater.GetSwitches();

        TTopologyStorage::THostSet hostsInSwitch;
        for (const auto host : switch_->GetRealHosts()) {
            auto hostRef = TTopology::THostRef(host);
            updater.AddHost(hostRef);
            hostsInSwitch.insert(hostRef);
        }
        updater.SpinAndWait().Wait();
        auto hostSetB = updater.GetHosts();
        auto switchSetB = updater.GetSwitches();

        UNIT_ASSERT(hostSetA->size() == 1);
        UNIT_ASSERT(hostSetA->contains(hostA));
        UNIT_ASSERT(switchSetA->empty());

        UNIT_ASSERT(hostSetB->size() == hostsInSwitch.size());
        for (const auto& host : hostsInSwitch) {
            UNIT_ASSERT(hostSetB->contains(host));
        }
        UNIT_ASSERT(switchSetB->size() == 1);
        UNIT_ASSERT(switchSetB->contains(switch_));
    }

    TTopologyStorage& TopologyStorage;
};

UNIT_TEST_SUITE_REGISTRATION(TLinkPollerHostsTest);
