#pragma once

#include <infra/netmon/topology/topology_storage.h>
#include <infra/netmon/statistics/histograms.h>

#include <infra/netmon/idl/aggregation.fbs.h>

namespace NNetmon {
    class TSwitchPairState;

    class TNetworkAvailability: public TNonCopyable {
    public:
        struct TAvailabilityState {
            // switch is alive when there is at least one probe
            // for queues and datacenters this is an average of switch values
            TAverage Alive;

#ifdef NOC_SLA_BUILD
            using TConnectivityHistogramType = TConnectivityHistogram;
#else
            using TConnectivityHistogramType = TAverageHistogram;
#endif

            // compute average connectivity across all probes on all levels
            TConnectivityHistogramType Connectivity;

            inline void Merge(const TAvailabilityState& other) {
                Alive.Merge(other.Alive);
                Connectivity.Merge(other.Connectivity);
            }

            inline void FromProto(const NAggregation::TSwitchAvailability& state) {
                Alive.FromProto(*state.Alive());
                Connectivity.FromProto(*state.Connectivity());
            }
        };

        using TSwitchMap = THashMap<TTopology::TSwitchRef, TAvailabilityState>;
        using TLineMap = THashMap<TTopology::TLineRef, TAvailabilityState>;
        using TDatacenterMap = THashMap<TTopology::TDatacenterRef, TAvailabilityState>;

        using TFlatState = flatbuffers::Vector<flatbuffers::Offset<NAggregation::TSwitchAvailability>>;

        inline size_t GetCount() const {
            return SwitchMap.size();
        }

        void FillMap(TSwitchMap& switchMap) const;
        void FillMap(TLineMap& queueMap) const;
        void FillMap(TDatacenterMap& datacenterMap) const;

        void MergeFrom(const TNetworkAvailability& other);
        void AddState(const TSwitchPairState& state, const TTopologySelector& selector);

        void FromProto(const TTopologyStorage& topologyStorage, const TFlatState& states);
        flatbuffers::Offset<TFlatState> ToProto(flatbuffers::FlatBufferBuilder& builder) const;

    private:
        TSwitchMap SwitchMap;
    };
}
