#pragma once

#include <infra/netmon/probe_aggregator.h>
#include <infra/netmon/slice_collector.h>
#include <infra/netmon/library/scheduler.h>

namespace NNetmon {
    class TProbeAggregatorMaintainer: public TNonCopyable {
    public:
        TProbeAggregatorMaintainer(const TSliceCollector& sliceCollector);
        ~TProbeAggregatorMaintainer();

        TProbeAggregator::TRef GetAggregator(const TProbeAggregatorKey &key) const;
        TProbeAggregator::TRefVector GetAggregators() const;
        TProbeAggregator::TRefVector FindAggregators(TExpressionId expressionId) const;
        bool ExpressionExists(TExpressionId expressionId) const;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
