#include <infra/netmon/probe_gatherer.h>
#include <infra/netmon/common_ut.h>
#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TProbeGathererTest: public TTestBase {
    UNIT_TEST_SUITE(TProbeGathererTest);
    UNIT_TEST(TestFindProbes)
    UNIT_TEST_SUITE_END();

public:
    TProbeGathererTest()
        : SliceKey{BACKBONE6, ICMP, 1}
        , Slice(SliceKey, GetTopologyStorage(), GetSeenHostsUpdater(), GetTerminatedHostsMaintainer(), GetWalleUpdater())
    {
        TVector<TProbe::TRef> probes;
        probes.emplace_back(CreateProbe("man1-0015.search.yandex.net", "sas1-1234.search.yandex.net"));
        probes.emplace_back(CreateProbe("jmon-test.search.yandex.net", "man1-0015.search.yandex.net"));
        Slice.InsertProbes(std::move(probes), TInstant::Now());
        SliceVector.emplace_back(&Slice);
    }

private:
    inline TProbeGatherer::TRef CreateGatherer() {
        return TProbeGatherer::Make(
            SliceVector,
            GetTopologyStorage().DefaultExpressionId(),
            GetTopologyStorage()
        );
    }

    inline void TestFindProbes() {
        const auto sourceHost(FindHost("man1-0015.search.yandex.net"));
        const auto targetHost(FindHost("sas1-1234.search.yandex.net"));

        {
            TProbeGatherer::TQuery query;
            query.SwitchKey.ConstructInPlace(targetHost.GetSwitch(), sourceHost.GetSwitch());
            const auto result(
                CreateGatherer()->FindProbes<TProbeStorage::TSwitchIndexAccessor>(query)
                    .GetValue(TDuration::Max())
            );
            UNIT_ASSERT_EQUAL(result.size(), 1);
        }

        {
            TProbeGatherer::TQuery query;
            query.QueueKey.ConstructInPlace(targetHost.GetLine(), sourceHost.GetLine());
            const auto result(
                CreateGatherer()->FindProbes<TProbeStorage::TLineIndexAccessor>(query)
                    .GetValue(TDuration::Max())
            );
            UNIT_ASSERT_EQUAL(result.size(), 1);
        }

        {
            TProbeGatherer::TQuery query;
            query.DatacenterKey.ConstructInPlace(targetHost.GetDatacenter(), sourceHost.GetDatacenter());
            const auto result(
                CreateGatherer()->FindProbes<TProbeStorage::TDatacenterIndexAccessor>(query)
                    .GetValue(TDuration::Max())
            );
            UNIT_ASSERT_EQUAL(result.size(), 1);
        }
    }

    const TProbeSliceKey SliceKey;
    TProbeSlice Slice;
    TProbeSlice::TRefVector SliceVector;
};

UNIT_TEST_SUITE_REGISTRATION(TProbeGathererTest);
