#pragma once

#include <infra/netmon/probe_scheduler.h>
#include <infra/netmon/library/boxes.h>
#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/topology/clients/walle.h>
#include <infra/netmon/racktables.h>

namespace NNetmon {
    class TProbeScheduleMaintainer: public TNonCopyable {
    public:
        using TProbeScheduleBox = TAtomicLockedBox<IProbeScheduler::TProbeSchedule>;
        using TProbeScheduleRef = TProbeScheduleBox::TConstValueRef;

        TProbeScheduleMaintainer(const TTopologyStorage& topologyStorage, const IHostsMaintainer& walleUpdater, const IHostsMaintainer& rtUpdater);
        ~TProbeScheduleMaintainer();

        TProbeScheduleRef GetSchedule() const noexcept;

        void AddInterestedHost(const TTopology::THostRef host);
        void AddLinkPollerStats(const TTopology::THostRef host, ui64 successCount, ui64 failCount);
        TTopologyStorage::THostSetRef GetInterestedHosts() const;

        TThreadPool::TFuture SpinAndWait() noexcept;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
