#pragma once

#include <infra/netmon/probe_slice_merger.h>
#include <infra/netmon/state_history_keys.h>

namespace NNetmon {
    class IProbeSliceDumper {
    public:
        using TSwitchCallback = std::function<void(THistoryLinePairKey, TSwitchPairIndex::TRef)>;
        using TLineCallback = std::function<void(THistoryDatacenterPairKey, TLinePairIndex::TRef)>;
        using TDatacenterCallback = std::function<void(THistoryRootKey, TDatacenterPairIndex::TRef)>;

        virtual ~IProbeSliceDumper() = default;

        virtual TSwitchPairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const = 0;
        virtual TLinePairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const = 0;
        virtual TDatacenterPairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key) const = 0;

        virtual void IterateSwitch(const TInstant& requestedTs, TSwitchCallback func) const = 0;
        virtual void IterateLine(const TInstant& requestedTs, TLineCallback func) const = 0;
        virtual void IterateDatacenter(const TInstant& requestedTs, TDatacenterCallback func) const = 0;

        virtual void IterateSwitch(const TInstant& since, const TInstant& until, TSwitchCallback func) const = 0;
        virtual void IterateLine(const TInstant& since, const TInstant& until, TLineCallback func) const = 0;
        virtual void IterateDatacenter(const TInstant& since, const TInstant& until, TDatacenterCallback func) const = 0;
    };

    class TProbeSliceDumper: public IProbeSliceDumper, public TNonCopyable {
    public:
        TProbeSliceDumper(const TTopologyStorage& topologyStorage,
                          const IProbeSliceMerger& sliceMerger);
        ~TProbeSliceDumper();

        bool IsReady() const noexcept;

        TSwitchPairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const override;
        TLinePairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const override;
        TDatacenterPairIndex::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key) const override;

        void IterateSwitch(const TInstant& requestedTs, TSwitchCallback func) const override;
        void IterateLine(const TInstant& requestedTs, TLineCallback func) const override;
        void IterateDatacenter(const TInstant& requestedTs, TDatacenterCallback func) const override;

        void IterateSwitch(const TInstant& since, const TInstant& until, TSwitchCallback func) const override;
        void IterateLine(const TInstant& since, const TInstant& until, TLineCallback func) const override;
        void IterateDatacenter(const TInstant& since, const TInstant& until, TDatacenterCallback func) const override;

        TThreadPool::TFuture WaitSwitchTask();
        TThreadPool::TFuture WaitLineTask();
        TThreadPool::TFuture WaitDatacenterTask();

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
