#pragma once

#include <infra/netmon/probe_slice_merger.h>
#include <infra/netmon/probe_slice_dumper.h>
#include <infra/netmon/state_index_history.h>

namespace NNetmon {
    class TProbeSliceHistory: public TNonCopyable {
    public:
        TProbeSliceHistory(const IProbeSliceMerger& sliceMerger, const IProbeSliceDumper& sliceDumper);
        ~TProbeSliceHistory();

        bool IsReady() const noexcept;
        bool IsSwitchReady() const noexcept;
        bool IsLineReady() const noexcept;
        bool IsDatacenterReady() const noexcept;

        TSwitchPairStateHistory::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TSwitchPairKey& pairKey) const;
        TLinePairStateHistory::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const;
        TDatacenterPairStateHistory::TRef Read(const TInstant& requestedTs, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const;

        TVector<TSwitchPairStateHistory::TRef> Read(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TSwitchPairKey& pairKey) const;
        TVector<TLinePairStateHistory::TRef> Read(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TLinePairKey& pairKey) const;
        TVector<TDatacenterPairStateHistory::TRef> Read(
                const TInstant& since, const TInstant& until, const TProbeAggregatorKey& key, const TDatacenterPairKey& pairKey) const;

        TDuration GetSwitchChunkDuration() const;
        TDuration GetLineChunkDuration() const;
        TDuration GetDatacenterChunkDuration() const;

        TThreadPool::TFuture WaitSwitchUpdate();
        TThreadPool::TFuture WaitLineUpdate();
        TThreadPool::TFuture WaitDatacenterUpdate();

        TThreadPool::TFuture WaitSwitchDump();
        TThreadPool::TFuture WaitLineDump();
        TThreadPool::TFuture WaitDatacenterDump();

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
