#pragma once

#include <infra/netmon/probe_slice.h>
#include <infra/netmon/probe_gatherer.h>
#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/seen_hosts.h>
#include <infra/netmon/terminated_hosts.h>
#include <infra/netmon/topology/clients/walle.h>

namespace NNetmon {
    class IProbeSliceMaintainer {
    public:
        virtual ~IProbeSliceMaintainer() = default;

        virtual TProbeSlice::TRefVector GetSliceList() const = 0;
        virtual TProbeSlice::TRefVector GetSliceList(const TProbeSectionKey& section) const = 0;
    };

    class TProbeSliceMaintainer: public IProbeSliceMaintainer, public TNonCopyable {
    public:
        TProbeSliceMaintainer(const TTopologyStorage& topologyStorage,
                              const TSeenHostsUpdater& seenHostsUpdater,
                              const TTerminatedHostsMaintainer& terminatedHostsMaintainer,
                              const TWalleUpdater& walleUpdater);
        ~TProbeSliceMaintainer();

        TProbeSlice::TRefVector GetSliceList() const override;
        TProbeSlice::TRefVector GetSliceList(const TProbeSectionKey& section) const override;
        TProbeGatherer::TRef CreateProbeGatherer(const TProbeAggregatorKey& key) const;
        TTopologyStorage::THostIdSet GetPartialSeenHosts() const;

        bool IsReady() const;

    private:
        TProbeSliceMaintainer(const TTopologyStorage& topologyStorage,
                              const TSeenHostsUpdater& seenHostsUpdater,
                              const TTerminatedHostsMaintainer& terminatedHostsMaintainer,
                              const TWalleUpdater& walleUpdater,
                              bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
