#include <infra/netmon/probe_slice_merger.h>
#include <infra/netmon/common_ut.h>
#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TFakeProbeSliceMaintainer: public IProbeSliceMaintainer, public TNonCopyable {
public:
    TFakeProbeSliceMaintainer()
        : SliceKey{BACKBONE6, ICMP, 1}
        , Slice(SliceKey, GetTopologyStorage(), GetSeenHostsUpdater(), GetTerminatedHostsMaintainer(), GetWalleUpdater())
    {
        TVector<TProbe::TRef> probes;
        probes.emplace_back(CreateProbe("man1-0015.search.yandex.net", "sas1-1234.search.yandex.net"));
        probes.emplace_back(CreateProbe("jmon-test.search.yandex.net", "man1-0015.search.yandex.net"));
        Slice.InsertProbes(std::move(probes), TInstant::Now());

        WaitForFuture(Slice.WaitSwitchTask());
        WaitForFuture(Slice.WaitQueueTask());
        WaitForFuture(Slice.WaitDatacenterTask());
    }

    TProbeSlice::TRefVector GetSliceList() const override {
        TProbeSlice::TRefVector result;
        result.emplace_back(&Slice);
        return result;
    }

    TProbeSlice::TRefVector GetSliceList(const TProbeSectionKey& section) const override {
        Y_VERIFY(SliceKey.GetSectionKey() == section);
        return GetSliceList();
    }

    const TProbeSliceKey& GetSliceKey() {
        return SliceKey;
    }

private:
    const TProbeSliceKey SliceKey;
    TProbeSlice Slice;
};

class TProbeSliceMergerTest: public TTestBase {
    UNIT_TEST_SUITE(TProbeSliceMergerTest);
    UNIT_TEST(TestMerge)
    UNIT_TEST_SUITE_END();

private:
    inline void TestMerge() {
        TFakeProbeSliceMaintainer sliceMaintainer;
        TProbeSliceMerger merger(sliceMaintainer);

        WaitForFuture(merger.WaitSwitchTask());
        WaitForFuture(merger.WaitQueueTask());
        WaitForFuture(merger.WaitDatacenterTask());

        UNIT_ASSERT_VALUES_EQUAL(merger.GetSwitchLevelKeys().size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(merger.GetLineLevelKeys().size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(merger.GetDatacenterLevelKeys().size(), 1);

        const auto key(TProbeAggregatorKey::FromSliceKey(
            sliceMaintainer.GetSliceKey(),
            GetTopologyStorage().DefaultExpressionId()
        ));

        UNIT_ASSERT(merger.GetSwitchLevelIndex(key));
        UNIT_ASSERT(merger.GetLineLevelIndex(key));
        UNIT_ASSERT(merger.GetDatacenterLevelIndex(key));
    }
};

UNIT_TEST_SUITE_REGISTRATION(TProbeSliceMergerTest);
