#include <infra/netmon/probe_slice.h>
#include <infra/netmon/common_ut.h>
#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TProbeSliceTest: public TTestBase {
    UNIT_TEST_SUITE(TProbeSliceTest);
    UNIT_TEST(TestInsertProbes)
    UNIT_TEST_SUITE_END();

public:
    TProbeSliceTest()
        : TopologyStorage(TGlobalTopology::GetTopologyStorage())
    {
    }

private:
    inline void TestInsertProbes() {
        TProbeSliceKey sliceKey{BACKBONE6, ICMP, 1};
        TProbeSlice slice(sliceKey, TopologyStorage, GetSeenHostsUpdater(), GetTerminatedHostsMaintainer(), GetWalleUpdater());
        UNIT_ASSERT(slice.SameSection(sliceKey.GetSectionKey()));

        TVector<TProbe::TRef> probes;
        probes.emplace_back(CreateProbe("man1-0015.search.yandex.net", "sas1-1234.search.yandex.net"));
        probes.emplace_back(CreateProbe("jmon-test.search.yandex.net", "man1-0015.search.yandex.net"));
        slice.InsertProbes(std::move(probes), TInstant::Now());

        WaitForFuture(slice.WaitSwitchTask());
        WaitForFuture(slice.WaitQueueTask());
        WaitForFuture(slice.WaitDatacenterTask());

        const TExpressionId defaultExpression = TopologyStorage.DefaultExpressionId();
        UNIT_ASSERT(!slice.GetSwitchLevelIndex()->find(defaultExpression).IsEnd());
        UNIT_ASSERT(!slice.GetLineLevelIndex()->find(defaultExpression).IsEnd());
        UNIT_ASSERT(!slice.GetDatacenterLevelIndex()->find(defaultExpression).IsEnd());
    }

    TTopologyStorage& TopologyStorage;
    const TTopologyStorage::THostSetBox Hosts;
};

UNIT_TEST_SUITE_REGISTRATION(TProbeSliceTest);
