#pragma once

#include <infra/netmon/topology/settings.h>
#include <infra/netmon/topology/metrics.h>
#include <infra/netmon/library/daemon_helper.h>
#include <infra/netmon/settings.h>
#include <infra/netmon/metrics.h>

namespace NNetmon {
    class TNetmonProvisioner : public TNonCopyable {
    public:
        void InitMetrics(TUnistat& tass) {
            TTopologyStatsInitializer().Init(tass);
            TStatsInitializer().Init(tass);
        }

        void ConfigureCommandLine(NLastGetopt::TOpts& opts) {
            NLastGetopt::TOpt& optTopologyFile = opts.AddLongOption("topology-file", "Path to topology file.");
            optTopologyFile.Optional().RequiredArgument().DefaultValue("topology.msgpack.gz");
        }

        void ParseCommandLine(NLastGetopt::TOpts& opts, NLastGetopt::TOptsParseResult& result) {
            TTopologySettings::Get()->SetTopologyFile(result.Get(opts.FindLongOption("topology-file")));
        }

        void LoadConfig(const NConfig::TConfig& config) {
            TTopologySettings::Get()->Load(config);
            TSettings::Get()->Load(config);
        }
    };
}
