#pragma once

#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/library/requester.h>
#include <infra/netmon/topology/topology_storage.h>
#include <infra/netmon/host_storage.h>

namespace NNetmon {
    class TRtUpdater: public IHostsMaintainer, public TNonCopyable {
    public:
        TRtUpdater(const TTopologyStorage& topologyStorage);
        ~TRtUpdater();

        TTopologyStorage::THostSetBox::TConstValueRef GetHosts() const;

    private:
        TRtUpdater(const TTopologyStorage& topologyStorage, bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
