#include <infra/netmon/provisioner.h>
#include <infra/netmon/api/aggregator_api.h>
#include <infra/netmon/api/expression_api.h>

using namespace NNetmon;

class TResolverDaemon: private TNonCopyable {
public:
    TResolverDaemon(TDaemonHelper& helper)
        : Helper(helper)
        , ExpressionStorage(false)
        , TopologyStorage(TopologyUpdater, ExpressionStorage, GroupStorage)
        , ExpressionContext(TopologyStorage, ExpressionStorage, GroupStorage)
        , ExpressionExpandHandler(ExpressionContext)
        , ResolverContext(TopologyStorage)
        , ResolverHostsHandler(ResolverContext)
    {
        Helper.RegisterHttpService("/api/expression/v1/expand", ExpressionExpandHandler);
        Helper.RegisterHttpService("/api/v1/hosts", ResolverHostsHandler);
    }

    void Run() {
        Helper.Run();
    }

private:
    TDaemonHelper& Helper;

    TGroupStorage GroupStorage;
    TExpressionStorage ExpressionStorage;
    TTopologyUpdater TopologyUpdater;
    TTopologyStorage TopologyStorage;

    TExpressionContextBase ExpressionContext;
    TExpressionExpandHandler ExpressionExpandHandler;
    TResolverContext ResolverContext;
    TResolverHostsHandler ResolverHostsHandler;
};

int main(int argc, const char** argv) {
    return TDaemonHelper::RunFromMain<TNetmonProvisioner, TResolverDaemon>(argc, argv);
}
