#pragma once

#include <infra/netmon/library/boxes.h>
#include <infra/netmon/library/scheduler.h>

namespace NNetmon {
    static const char* PROBES_TABLE_FORMAT = "%Y%m%d%H";
    static const TStringBuf PROBES_TABLE_PREFIX = "probes_";

    class TSchemaMaintainer: public TNonCopyable {
    public:
        TSchemaMaintainer();
        ~TSchemaMaintainer();

        TThreadPool::TFuture SpinAndWait() noexcept;

    private:
        TSchemaMaintainer(bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
