#pragma once

#include <infra/netmon/host_storage.h>
#include <infra/netmon/library/scheduler.h>

#include <util/generic/map.h>

namespace NNetmon {
    class TSeenHostsUpdater: public IHostsMaintainer, public TNonCopyable {
    public:
        TSeenHostsUpdater(const TTopologyStorage& topologyStorage);
        ~TSeenHostsUpdater();

        TTopologyStorage::THostSetBox::TConstValueRef GetHosts() const override;

        bool IsReady() const;

        const TVoidEventHub& OnChanged() const;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };

    class TSeenHostsMaintainer: public TNonCopyable {
    public:
        TSeenHostsMaintainer(const TTopologyStorage& topologyStorage, const TSeenHostsUpdater& seenHostsUpdater);
        ~TSeenHostsMaintainer();

        struct TState: public TNonCopyable {
            TState(TTopologySelector::TBox::TConstValueRef topologySelector, TExpressionId expressionId);

            // for storing in lexical order
            template <class T>
            struct TLess {
                bool operator()(const T& left, const T& right) const {
                    return left->GetName() < right->GetName();
                }
            };

            TTopologyStorage::THostSet Hosts;
            std::size_t TotalHosts;
            TMap<TTopology::TDatacenterRef, std::pair<std::size_t, std::size_t>, TLess<TTopology::TDatacenterRef>> CountByDc;
            TMap<TTopology::TLineRef, std::pair<std::size_t, std::size_t>, TLess<TTopology::TLineRef>> CountByQueue;
        };

        struct TStateMap {
            using TBox = TAtomicLockedBox<TStateMap>;
            using TConstValueRef = TBox::TConstValueRef;

            THashMap<TExpressionId, TState> States;
            TInstant Timestamp;
        };

        TStateMap::TConstValueRef GetStateMap() const;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TVoidEventHub::TSubscriptionGuard SeenHostsSubscription;
    };
}
