#pragma once

#include <infra/netmon/probe_storage.h>
#include <infra/netmon/library/api_client_helpers.h>

#include <infra/netmon/idl/api.fbs.h>

namespace NNetmon {
    class TSliceCollector: public TNonCopyable {
    public:
        using TProbesResponseList = TVector<TFlatObject<NApi::TProbesResponse>>;

        TSliceCollector(const TTopologyStorage& topologyStorage);
        ~TSliceCollector();

        void FillKeys(TProbeAggregatorKeySet& keys) const;

        TSwitchPairIndex::TRef GetSwitchIndex(const TProbeAggregatorKey& key) const;
        TLinePairIndex::TRef GetLineIndex(const TProbeAggregatorKey& key) const;
        TDatacenterPairIndex::TRef GetDatacenterIndex(const TProbeAggregatorKey& key) const;

        NThreading::TFuture<TProbesResponseList> CollectProbes(const flatbuffers::FlatBufferBuilder& builder) const;

        bool IsReady() const;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
