#include <infra/netmon/schema_maintainer.h>
#include <infra/netmon/api/common_api.h>
#include <infra/netmon/api/slicer_api.h>
#include <infra/netmon/monitors.h>
#include <infra/netmon/provisioner.h>
#include <infra/netmon/metrics_updater.h>
#include <infra/netmon/probe_slice_dumper.h>
#include <infra/netmon/probe_slice_history.h>
#include <infra/netmon/share_dead_hosts.h>
#include <infra/netmon/topology/topology_updater.h>
#include <infra/netmon/topology/topology_storage.h>

using namespace NNetmon;

class TSlicerDaemon: private TNonCopyable {
public:
    TSlicerDaemon(TDaemonHelper& helper)
        : Helper(helper)
        , ExpressionStorage(!TLibrarySettings::Get()->GetZookeeperUri().empty())
        , TopologyStorage(TopologyUpdater, ExpressionStorage, GroupStorage)
        , ClickhouseDumper(Queue)
        , SeenHostsUpdater(TopologyStorage)
        , TerminatedHostsMaintainer(TopologyStorage)
        , WalleUpdater(TopologyStorage, CalculateWalleUpdaterTimeOffset())
        , ProbeSliceMaintainer(TopologyStorage, SeenHostsUpdater, TerminatedHostsMaintainer, WalleUpdater)
        , ProbeSliceMerger(ProbeSliceMaintainer)
        , ProbeSliceDumper(TopologyStorage, ProbeSliceMerger)
        , ProbeSliceHistory(ProbeSliceMerger, ProbeSliceDumper)
        , WalleUpdaterSubscription(WalleUpdater.OnUpdated().Subscribe([this](){
              ShareDeadHosts(WalleUpdater);
          }))
        // slicer handlers
        , SlicerContext(ExpressionStorage, ProbeSliceMaintainer,
                        ProbeSliceMerger, ProbeSliceDumper, ProbeSliceHistory,
                        TopologyStorage, SeenHostsUpdater, TerminatedHostsMaintainer,
                        WalleUpdater, ClickhouseDumper, ClickhouseMonitor, Queue)
        , DatacenterStateHandler(SlicerContext)
        , QueueStateHandler(SlicerContext)
        , SwitchStateHandler(SlicerContext)
        , DatacenterHistoryStateHandler(SlicerContext)
        , QueueHistoryStateHandler(SlicerContext)
        , SwitchHistoryStateHandler(SlicerContext)
        , DatacenterHistorySeriesHandler(SlicerContext)
        , QueueHistorySeriesHandler(SlicerContext)
        , SwitchHistorySeriesHandler(SlicerContext)
        , AggregatorKeysHandler(SlicerContext)
        , ProbesHandler(SlicerContext)
        , SeenHostsHandler(SlicerContext)
        , TerminatedHostsHandler(SlicerContext)
        , UpdateTerminatedHostsHandler(SlicerContext)
        , AppendProbesHandler(SlicerContext)
        , SlicerPingHandler(SlicerContext)
        // common handles
        , CommonContext(TopologyStorage)
        , MetricsStatsHandler(CommonContext)
        , AllocStatsHandler(CommonContext)
        , DummyQualityStatsHandler(CommonContext)
    {
        // create schema
        SchemaMaintainer.SpinAndWait().Wait();

        // interconnect handles
        Helper.RegisterInterconnectService("/slicer/v1/datacenter_state", DatacenterStateHandler);
        Helper.RegisterInterconnectService("/slicer/v1/queue_state", QueueStateHandler);
        Helper.RegisterInterconnectService("/slicer/v1/switch_state", SwitchStateHandler);

        Helper.RegisterInterconnectService("/slicer/v1/datacenter_history_state", DatacenterHistoryStateHandler);
        Helper.RegisterInterconnectService("/slicer/v1/queue_history_state", QueueHistoryStateHandler);
        Helper.RegisterInterconnectService("/slicer/v1/switch_history_state", SwitchHistoryStateHandler);

        Helper.RegisterInterconnectService("/slicer/v1/datacenter_history_series", DatacenterHistorySeriesHandler);
        Helper.RegisterInterconnectService("/slicer/v1/queue_history_series", QueueHistorySeriesHandler);
        Helper.RegisterInterconnectService("/slicer/v1/switch_history_series", SwitchHistorySeriesHandler);

        Helper.RegisterInterconnectService("/slicer/v1/aggregator_keys", AggregatorKeysHandler);
        Helper.RegisterInterconnectService("/slicer/v1/probes", ProbesHandler);
        Helper.RegisterInterconnectService("/slicer/v1/seen_hosts", SeenHostsHandler);
        Helper.RegisterInterconnectService("/slicer/v1/update_terminated_hosts", UpdateTerminatedHostsHandler);
        Helper.RegisterInterconnectService("/slicer/v1/terminated_hosts", TerminatedHostsHandler);
        Helper.RegisterInterconnectService("/slicer/v1/append_probes", AppendProbesHandler);

        // http handles
        Helper.RegisterHttpService("/api/v1/ping", SlicerPingHandler);

        // common handles
        Helper.RegisterHttpService("/api/v1/metrics", MetricsStatsHandler);
        Helper.RegisterHttpService("/api/v1/allocator", AllocStatsHandler);
        Helper.RegisterHttpService("/api/v1/quality", DummyQualityStatsHandler);
    }

    void Run() {
        TClickhouseDumper::TThreadGuard dumperGuard(ClickhouseDumper);
        Helper.Run();
    }

private:
    TDaemonHelper& Helper;

    TCommonMetricsUpdater CommonMetricsUpdater;

    TGroupStorage GroupStorage;
    TExpressionStorage ExpressionStorage;
    TTopologyUpdater TopologyUpdater;
    TTopologyStorage TopologyStorage;

    TSchemaMaintainer SchemaMaintainer;

    TDumperProbeBatch::TRecordQueue Queue;
    TClickhouseDumper ClickhouseDumper;
    TClickhouseMonitor ClickhouseMonitor;

    TSeenHostsUpdater SeenHostsUpdater;
    TTerminatedHostsMaintainer TerminatedHostsMaintainer;
    TWalleUpdater WalleUpdater;
    TProbeSliceMaintainer ProbeSliceMaintainer;
    TProbeSliceMerger ProbeSliceMerger;
    TProbeSliceDumper ProbeSliceDumper;
    TProbeSliceHistory ProbeSliceHistory;

    TVoidEventHub::TSubscriptionGuard WalleUpdaterSubscription;

    TSlicerContext SlicerContext;

    TDatacenterStateHandler DatacenterStateHandler;
    TLineStateHandler QueueStateHandler;
    TSwitchStateHandler SwitchStateHandler;

    TDatacenterHistoryStateHandler DatacenterHistoryStateHandler;
    TLineHistoryStateHandler QueueHistoryStateHandler;
    TSwitchHistoryStateHandler SwitchHistoryStateHandler;

    TDatacenterHistorySeriesHandler DatacenterHistorySeriesHandler;
    TLineHistorySeriesHandler QueueHistorySeriesHandler;
    TSwitchHistorySeriesHandler SwitchHistorySeriesHandler;

    TAggregatorKeysHandler AggregatorKeysHandler;
    TProbesHandler ProbesHandler;
    TSlicerSeenHostsHandler SeenHostsHandler;
    TSlicerTerminatedHostsHandler TerminatedHostsHandler;
    TUpdateTerminatedHostsHandler UpdateTerminatedHostsHandler;
    TAppendProbesHandler AppendProbesHandler;
    TSlicerPingHandler SlicerPingHandler;

    TCommonContext CommonContext;
    TMetricsStatsHandler MetricsStatsHandler;
    TAllocStatsHandler AllocStatsHandler;
    TDummyQualityStatsHandler DummyQualityStatsHandler;
};

int main(int argc, const char** argv) {
    return TDaemonHelper::RunFromMain<TNetmonProvisioner, TSlicerDaemon>(argc, argv);
}
