#include <infra/netmon/state_history_keys.h>

#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TStateHistoryKeysTest: public TTestBase {
    UNIT_TEST_SUITE(TStateHistoryKeysTest);
    UNIT_TEST(TestDumpRootKey)
    UNIT_TEST(TestDumpSwitchKey)
    UNIT_TEST(TestDumpLineKey)
    UNIT_TEST(TestDumpDatacenterKey)
    UNIT_TEST_SUITE_END();

public:
    TStateHistoryKeysTest()
        : TopologyStorage(TGlobalTopology::GetTopologyStorage())
        , SourceHost(TopologyStorage.FindHost("man1-7521.search.yandex.net"))
        , TargetHost(TopologyStorage.FindHost("sas1-1234.search.yandex.net"))
        , DatacenterPairKey(TargetHost.GetDatacenter(), SourceHost.GetDatacenter())
        , LinePairKey(TargetHost.GetLine(), SourceHost.GetLine())
        , SwitchPairKey(TargetHost.GetSwitch(), SourceHost.GetSwitch())
        , AggregatorKey(TopologyStorage.DefaultExpressionId(), NIL_NETWORK, NIL_PROTOCOL)
    {
    }

    inline void TestDumpRootKey() {
        const THistoryRootKey key(AggregatorKey);
        const THistoryRootKey restoredKey(TopologyStorage, key.AsTuple());
        UNIT_ASSERT_EQUAL(key, restoredKey);
    }

    inline void TestDumpSwitchKey() {
        const THistorySwitchPairKey key(AggregatorKey, SwitchPairKey);
        const THistorySwitchPairKey restoredKey(TopologyStorage, key.AsTuple());
        UNIT_ASSERT_EQUAL(key, restoredKey);
    }

    inline void TestDumpLineKey() {
        const THistoryLinePairKey key(AggregatorKey, LinePairKey);
        const THistoryLinePairKey restoredKey(TopologyStorage, key.AsTuple());
        UNIT_ASSERT_EQUAL(key, restoredKey);
    }

    inline void TestDumpDatacenterKey() {
        const THistoryDatacenterPairKey key(AggregatorKey, DatacenterPairKey);
        const THistoryDatacenterPairKey restoredKey(TopologyStorage, key.AsTuple());
        UNIT_ASSERT_EQUAL(key, restoredKey);
    }

    const TTopologyStorage& TopologyStorage;
    const TTopology::THostRef SourceHost;
    const TTopology::THostRef TargetHost;
    const TDatacenterPairKey DatacenterPairKey;
    const TLinePairKey LinePairKey;
    const TSwitchPairKey SwitchPairKey;
    const TProbeAggregatorKey AggregatorKey;
};

UNIT_TEST_SUITE_REGISTRATION(TStateHistoryKeysTest);
