#include <infra/netmon/state_index_history.h>
#include <infra/netmon/settings.h>

namespace NNetmon {
    TSwitchPairStateHistory::TSwitchPairStateHistory(const TTopology::TSwitchRef& target,
                                                     const TTopology::TSwitchRef& source)
        : THistoryPairState(target, source, TSettings::Get()->GetSwitchAggregationInterval())
    {
    }

    TSwitchPairStateHistory::TSwitchPairStateHistory(const TTopology::TSwitchRef& target,
                                                     const TTopology::TSwitchRef& source,
                                                     const NHistory::TSwitchPairStateHistory& state)
        : THistoryPairState(target, source, state)
    {
    }

    TSwitchPairStateHistory::TSwitchPairStateHistory(const TSwitchPairStateHistory& other)
        : THistoryPairState(other)
    {
    }

    flatbuffers::Offset<NHistory::TSwitchPairStateHistory> TSwitchPairStateHistory::ToProto(flatbuffers::FlatBufferBuilder& builder) const {
        TGuard<TAdaptiveLock> guard(UpdateLock);
        ConnectivitySeries.Finish();
        RttSeries.Finish();
        TimestampSeries.Finish();
        return NHistory::CreateTSwitchPairStateHistory(
            builder,
            ConnectivitySeries.ToProto(builder),
            RttSeries.ToProto(builder),
            TimestampSeries.ToProto(builder)
        );
    }

    TSwitchPairIndexHistory::TSwitchPairIndexHistory(const TProbeAggregatorKey& key)
        : THistoryPairIndex(key)
    {
    }

    TLinePairStateHistory::TLinePairStateHistory(const TTopology::TLineRef& target,
                                                 const TTopology::TLineRef& source)
        : THistoryPairState(target, source, TSettings::Get()->GetLineAggregationInterval())
    {
    }

    TLinePairStateHistory::TLinePairStateHistory(const TTopology::TLineRef& target,
                                                 const TTopology::TLineRef& source,
                                                 const NHistory::TLinePairStateHistory& state)
        : THistoryPairState(target, source, state)
    {
    }

    TLinePairStateHistory::TLinePairStateHistory(const TLinePairStateHistory& other)
        : THistoryPairState(other)
    {
    }

    flatbuffers::Offset<NHistory::TLinePairStateHistory> TLinePairStateHistory::ToProto(flatbuffers::FlatBufferBuilder& builder) const {
        TGuard<TAdaptiveLock> guard(UpdateLock);
        ConnectivitySeries.Finish();
        RttSeries.Finish();
        TimestampSeries.Finish();
        return NHistory::CreateTLinePairStateHistory(
            builder,
            ConnectivitySeries.ToProto(builder),
            RttSeries.ToProto(builder),
            TimestampSeries.ToProto(builder)
        );
    }

    TLinePairIndexHistory::TLinePairIndexHistory(const TProbeAggregatorKey& key)
        : THistoryPairIndex(key)
    {
    }

    TDatacenterPairStateHistory::TDatacenterPairStateHistory(const TTopology::TDatacenterRef& target,
                                                             const TTopology::TDatacenterRef& source)
        : THistoryPairState(target, source, TSettings::Get()->GetDcAggregationInterval())
    {
    }

    TDatacenterPairStateHistory::TDatacenterPairStateHistory(const TTopology::TDatacenterRef& target,
                                                             const TTopology::TDatacenterRef& source,
                                                             const NHistory::TDatacenterPairStateHistory& state)
        : THistoryPairState(target, source, state)
    {
    }

    TDatacenterPairStateHistory::TDatacenterPairStateHistory(const TDatacenterPairStateHistory& other)
        : THistoryPairState(other)
    {
    }

    flatbuffers::Offset<NHistory::TDatacenterPairStateHistory> TDatacenterPairStateHistory::ToProto(flatbuffers::FlatBufferBuilder& builder) const {
        TGuard<TAdaptiveLock> guard(UpdateLock);
        ConnectivitySeries.Finish();
        RttSeries.Finish();
        TimestampSeries.Finish();
        return NHistory::CreateTDatacenterPairStateHistory(
            builder,
            ConnectivitySeries.ToProto(builder),
            RttSeries.ToProto(builder),
            TimestampSeries.ToProto(builder)
        );
    }

    TDatacenterPairIndexHistory::TDatacenterPairIndexHistory(const TProbeAggregatorKey& key)
        : THistoryPairIndex(key)
    {
    }
}
