#pragma once

#include <infra/netmon/topology/topology_storage.h>

#include <infra/netmon/idl/api.fbs.h>

namespace NNetmon {
    class IStateRequester {
    public:
        virtual ~IStateRequester() = default;

        virtual NApi::ELevel GetLevel() const = 0;
        virtual const TDuration& GetInterval() const = 0;
        virtual std::size_t GetRequestLimit() const = 0;
        virtual std::size_t GetBatchSize() const = 0;

        virtual TThreadPool::TFuture Collect(
            const TString& path, const flatbuffers::FlatBufferBuilder& builder) = 0;
    };

    class TStatePicker: public TNonCopyable {
    public:
        TStatePicker(IStateRequester& requester);
        ~TStatePicker();

        TThreadPool::TFuture Run();
        TInstant GetDeadline() const;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
