#pragma once

#include <infra/netmon/idl/accumulators.fbs.h>

#include <util/generic/maybe.h>

namespace NNetmon {
    class TDescriptiveStatistics {
    public:
        TDescriptiveStatistics() = default;
        TDescriptiveStatistics(const TDescriptiveStatistics& other);
        TDescriptiveStatistics(const NCommon::TDescriptiveStatistics& statistics);

        void Append(double value);
        void Merge(const TDescriptiveStatistics& other);

        TMaybe<double> Mean();
        TMaybe<double> Variance();

        flatbuffers::Offset<NCommon::TDescriptiveStatistics> ToProto(
                flatbuffers::FlatBufferBuilder& builder) const;
        void FromProto(const NCommon::TDescriptiveStatistics& statistics);

        TDescriptiveStatistics& operator=(const TDescriptiveStatistics& other);

    private:
        std::size_t Count = 0;
        double MeanMoment = 0.0;
        double VarianceMoment = 0.0;
    };
}
